 ; Ŀ
 ;   Moss: Move entities from model to paper space.                        
 ;   Copyright 1995, 1997 by Rocket Software                               
 ;                                                                         
 ; 

 ; Ŀ
 ;   Msam - check subentities for mistaken 67 (space indicator) codes.     
 ; 
 (DEFUN MSAM (enam / mods entt asoc67)
  (while (/= "SEQEND" 
             (cdr (assoc 0 (setq entt (entget (setq enam (entnext enam)))))))
         (cond ((null (assoc 67 entt))
                 (entmod (append entt (list (cons 67 1))))
                 (marke (cdr (assoc 10 entt)))
                 (setq mods t))
               ((= (cdr (setq asoc67 (assoc 67 entt))) 0)
                (entmod (subst (cons 67 1) asoc67 entt))
                (marke (cdr (assoc 10 entt)))
                (setq mods t))))
  (if mods (entupd enam))
 (princ))
 ; Ŀ
 ;   Msam end.                                                             
 ; 

 ; Ŀ
 ;   Marke - mark a point.                                                 
 ; 
 (DEFUN MARKE (pa / rad)
  (setq rad (/ (getvar "viewsize") 45))
  (grdraw (polar pa (/ pi 4) rad) (polar pa (* 1.25 pi) rad) 7)
  (grdraw (polar pa (* pi 0.75) rad) (polar pa (* pi 1.75) rad) 7)
 (princ))
 ; Ŀ
 ;   Marke end.                                                            
 ; 

 ; Ŀ
 ;   Moss.                                                                 
 ; 
 (DEFUN C:MOSS (/ pa ss num enam entt)
  (setvar "cmdecho" 1)
  (command ".undo" "m")
  (setvar "tilemode" 0)
  (command ".mspace")
  (setq pa (trans '(0 0) 3 2))
  (write-line "Select stuff to suck into paper space: ")
  (setq ss (ssget (list (cons 67 0))))
  (setq num 0)
  (while (and ss (setq enam (ssname ss num)))
         (setq num (1+ num))
         (setq entt (entget enam))
         (if (assoc 67 entt)
             (setq entt (subst (cons 67 1) (assoc 67 entt) entt))
             (setq entt (append entt (list (cons 67 1)))))
         (entmod entt))
  (command ".pspace")
  (command "move" ss "" pa "0,0")
  (setq ss (ssget "x" (list (cons 66 1))))
  (setq num 0)
  (while (and ss (setq enam (ssname ss num)))
         (setq num (1+ num))
         (msam enam))
  (command ".mspace")
 (princ))